
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 15 10:19:22 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AESFLOW_Acceptance_test_vectors.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  RYS_SYS_TST_FLOW_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for OTF Acceptance tests                              
 *
 **************************/
 
 
 
 /***** Include Files ******/
#include "CRYS_ATP_TST_AESFLOW_Acceptance.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/


/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/

 
/* input data values */
DxUint8_t 	TST_Input_Data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS] = 
		{0x2a,0xf2,0x60,0xf7,0xf9,0x4e,0x2b,0x31,0xbd,0xf2,0xb3,0x80,0x57,0xc8,0x87,0x4a,
		0x6d,0x70,0x12,0x59,0x6a,0x37,0xc3,0x77,0xc6,0x47,0x6b,0x3b,0x87,0x1b,0xe6,0x22,
		0x08,0x36,0xfd,0xe1,0xf9,0x15,0x8b,0xfa,0xa7,0x62,0xdf,0x8e,0x7d,0x6a,0x62,0x72,
		0xcb,0xd1,0x79,0x85,0xc7,0x84,0xad,0x40,0xd2,0xf0,0x0a,0x8e,0xfc,0x72,0xc4,0xde,
		0xc9,0x0e,0x21,0x77,0x36,0x63,0x92,0x0c,0xf7,0xde,0x23,0x91,0x03,0x2f,0x16,0x4d,
		0x52,0xf9,0xcb,0x2f,0xe5,0xce,0xe4,0x65,0x08,0x5a,0xa6,0x2b,0xd4,0xde,0xa1,0xe1,
		0xf7,0xe1,0x93,0x61,0xb8,0x22,0x8a,0x8f,0x35,0xd0,0x49,0x32,0xef,0xfd,0xed,0x02,
		0x89,0x51,0xd0,0x01,0xcd,0xfb,0xae,0x0f,0xf0,0xed,0x06,0xb9,0x17,0x49,0xc3,0x53,
		0x19,0x16,0x1c,0x46,0x87,0x38,0xb9,0xaa,0xea,0x9f,0x17,0x18,0x4b,0xbe,0x2d,0xb9,
		0xf9,0x3f,0x50,0xa3,0x86,0xf5,0x54,0x66,0x13,0x12,0xf4,0xe1,0xcd,0x9a,0x73,0x5b,
		0xb8,0x17,0x84,0xcf,0xac,0x8f,0x68,0x86,0x9d,0xb3,0x56,0xeb,0x1f,0x59,0x1f,0x9c,
		0x28,0x2c,0x12,0xbd,0x18,0xa2,0x1d,0x91,0xf8,0x2f,0x36,0x4b,0xff,0xb9,0xf9,0x21,
		0x5b,0x4b,0x93,0xa3,0x2e,0x0d,0xde,0x4b,0xd6,0x74,0xcd,0x55,0x71,0xb6,0x0b,0xd0,
		0xa0,0x81,0xdf,0xf6,0x8c,0xec,0x53,0xb9,0x27,0xae,0x95,0x9e,0xb5,0x8d,0x9d,0xce,
		0x8a,0x1a,0x10,0x6b,0x15,0x9c,0x65,0x20,0x1d,0x4a,0x46,0xfc,0x4b,0xbd,0x39,0x80,
		0xe9,0xa4,0x7f,0xf6,0xe9,0xba,0x3c,0x05,0x29,0xf5,0xd9,0x83,0xf5,0x00,0xa7,0x8a,
		0xce,0xec,0xc5,0xce,0x69,0x23,0x43,0x2d,0xfb,0x9d,0x87,0x88,0xb4,0x56,0xf0,0xd2,
		0x89,0xff,0xba,0x66,0x37,0xf3,0x22,0x9e,0x85,0x6e,0xca,0xa1,0xc9,0xf9,0x5e,0x7c,
		0xad,0x29,0x78,0x75,0x33,0x89,0xc1,0x9b,0xf7,0xd5,0x5a,0xa2,0xb5,0x69,0x7a,0xee,
		0x0a,0xf8,0x58,0xee,0x7f,0x81,0x4b,0xab,0xc3,0x7f,0x2f,0xa1,0x38,0x61,0x0c,0xcd,
		0xb1,0x39,0xf2,0x07,0x7b,0xb8,0x27,0x92,0x9a,0x5a,0x85,0xf2,0x54,0xde,0x1d,0xfd,
		0xf4,0xf9,0x20,0x35,0xc8,0x4b,0x00,0x55,0x6c,0x92,0xd2,0x2a,0x4a,0x1e,0xf7,0xa4,
		0x62,0x85,0xfb,0x2d,0x47,0x97,0xbd,0x39,0x6a,0x94,0xd0,0x1f,0x9b,0x9d,0x22,0x27,
		0xcd,0x69,0xdb,0xe4,0x1a,0x39,0x88,0xc4,0x07,0x0e,0x79,0xe5,0x08,0x19,0x67,0x2a,
		0x47,0x73,0x5b,0x8f,0xa1,0x0e,0xca,0xb9,0xf1,0xec,0x05,0xd2,0x92,0x8e,0xd1,0x93,
		0x1f,0xb0,0x51,0xa2,0x7d,0x33,0x2d,0x1f,0x1c,0x5b,0xed,0x79,0x79,0x3a,0xa6,0x87,
		0xe8,0x6c,0xd9,0xd4,0x90,0x05,0x98,0x3a,0xb7,0xc8,0xea,0xb2,0x40,0x9a,0x71,0x6a,
		0x71,0x36,0x4a,0x18,0xfa,0x21,0x35,0x8f,0x33,0xe1,0xf6,0x8f,0xa6,0x6a,0xfb,0xe2,
		0xcd,0xd9,0x3e,0xa4,0x1d,0x64,0x6d,0xe3,0x43,0x91,0x49,0x68,0xad,0xa7,0x4c,0xd3,
		0x4c,0x62,0x8e,0xee,0x98,0xeb,0xe9,0x3b,0xd5,0x07,0x5b,0xcf,0x95,0x8f,0xad,0x63,
		0x7f,0x20,0x52,0xa9,0x4e,0x13,0x92,0xdc,0x1d,0xb0,0xe8,0x9b,0xe1,0x9e,0xa8,0xf7,
		0x37,0x9e,0xe4,0xcb,0x60,0x7a,0x91,0x4c,0x89,0x37,0xe6,0xe0,0x50,0x92,0x05,0x34};
		
DxUint8_t 	TST_Input_Data_ForCyclicOperation[TST_FLOW_DATA_VEC_SIZE_IN_BYTS] = 
		{0x2a,0xf2,0x60,0xf7,0xf9,0x4e,0x2b,0x31,0xbd,0xf2,0xb3,0x80,0x57,0xc8,0x87,0x4a,
		0x6d,0x70,0x12,0x59,0x6a,0x37,0xc3,0x77,0xc6,0x47,0x6b,0x3b,0x87,0x1b,0xe6,0x22,
		0x08,0x36,0xfd,0xe1,0xf9,0x15,0x8b,0xfa,0xa7,0x62,0xdf,0x8e,0x7d,0x6a,0x62,0x72,
		0xcb,0xd1,0x79,0x85,0xc7,0x84,0xad,0x40,0xd2,0xf0,0x0a,0x8e,0xfc,0x72,0xc4,0xde,
		0xc9,0x0e,0x21,0x77,0x36,0x63,0x92,0x0c,0xf7,0xde,0x23,0x91,0x03,0x2f,0x16,0x4d,
		0x52,0xf9,0xcb,0x2f,0xe5,0xce,0xe4,0x65,0x08,0x5a,0xa6,0x2b,0xd4,0xde,0xa1,0xe1,
		0xf7,0xe1,0x93,0x61,0xb8,0x22,0x8a,0x8f,0x35,0xd0,0x49,0x32,0xef,0xfd,0xed,0x02,
		0x89,0x51,0xd0,0x01,0xcd,0xfb,0xae,0x0f,0xf0,0xed,0x06,0xb9,0x17,0x49,0xc3,0x53,
		0x19,0x16,0x1c,0x46,0x87,0x38,0xb9,0xaa,0xea,0x9f,0x17,0x18,0x4b,0xbe,0x2d,0xb9,
		0xf9,0x3f,0x50,0xa3,0x86,0xf5,0x54,0x66,0x13,0x12,0xf4,0xe1,0xcd,0x9a,0x73,0x5b,
		0xb8,0x17,0x84,0xcf,0xac,0x8f,0x68,0x86,0x9d,0xb3,0x56,0xeb,0x1f,0x59,0x1f,0x9c,
		0x28,0x2c,0x12,0xbd,0x18,0xa2,0x1d,0x91,0xf8,0x2f,0x36,0x4b,0xff,0xb9,0xf9,0x21,
		0x5b,0x4b,0x93,0xa3,0x2e,0x0d,0xde,0x4b,0xd6,0x74,0xcd,0x55,0x71,0xb6,0x0b,0xd0,
		0xa0,0x81,0xdf,0xf6,0x8c,0xec,0x53,0xb9,0x27,0xae,0x95,0x9e,0xb5,0x8d,0x9d,0xce,
		0x8a,0x1a,0x10,0x6b,0x15,0x9c,0x65,0x20,0x1d,0x4a,0x46,0xfc,0x4b,0xbd,0x39,0x80,
		0xe9,0xa4,0x7f,0xf6,0xe9,0xba,0x3c,0x05,0x29,0xf5,0xd9,0x83,0xf5,0x00,0xa7,0x8a,
		0x2a,0xf2,0x60,0xf7,0xf9,0x4e,0x2b,0x31,0xbd,0xf2,0xb3,0x80,0x57,0xc8,0x87,0x4a,
		0x6d,0x70,0x12,0x59,0x6a,0x37,0xc3,0x77,0xc6,0x47,0x6b,0x3b,0x87,0x1b,0xe6,0x22,
		0x08,0x36,0xfd,0xe1,0xf9,0x15,0x8b,0xfa,0xa7,0x62,0xdf,0x8e,0x7d,0x6a,0x62,0x72,
		0xcb,0xd1,0x79,0x85,0xc7,0x84,0xad,0x40,0xd2,0xf0,0x0a,0x8e,0xfc,0x72,0xc4,0xde,
		0xc9,0x0e,0x21,0x77,0x36,0x63,0x92,0x0c,0xf7,0xde,0x23,0x91,0x03,0x2f,0x16,0x4d,
		0x52,0xf9,0xcb,0x2f,0xe5,0xce,0xe4,0x65,0x08,0x5a,0xa6,0x2b,0xd4,0xde,0xa1,0xe1,
		0xf7,0xe1,0x93,0x61,0xb8,0x22,0x8a,0x8f,0x35,0xd0,0x49,0x32,0xef,0xfd,0xed,0x02,
		0x89,0x51,0xd0,0x01,0xcd,0xfb,0xae,0x0f,0xf0,0xed,0x06,0xb9,0x17,0x49,0xc3,0x53,
		0x19,0x16,0x1c,0x46,0x87,0x38,0xb9,0xaa,0xea,0x9f,0x17,0x18,0x4b,0xbe,0x2d,0xb9,
		0xf9,0x3f,0x50,0xa3,0x86,0xf5,0x54,0x66,0x13,0x12,0xf4,0xe1,0xcd,0x9a,0x73,0x5b,
		0xb8,0x17,0x84,0xcf,0xac,0x8f,0x68,0x86,0x9d,0xb3,0x56,0xeb,0x1f,0x59,0x1f,0x9c,
		0x28,0x2c,0x12,0xbd,0x18,0xa2,0x1d,0x91,0xf8,0x2f,0x36,0x4b,0xff,0xb9,0xf9,0x21,
		0x5b,0x4b,0x93,0xa3,0x2e,0x0d,0xde,0x4b,0xd6,0x74,0xcd,0x55,0x71,0xb6,0x0b,0xd0,
		0xa0,0x81,0xdf,0xf6,0x8c,0xec,0x53,0xb9,0x27,0xae,0x95,0x9e,0xb5,0x8d,0x9d,0xce,
		0x8a,0x1a,0x10,0x6b,0x15,0x9c,0x65,0x20,0x1d,0x4a,0x46,0xfc,0x4b,0xbd,0x39,0x80,
		0xe9,0xa4,0x7f,0xf6,0xe9,0xba,0x3c,0x05,0x29,0xf5,0xd9,0x83,0xf5,0x00,0xa7,0x8a};


TST_AESFLOW_TestDataStruct TST_AESFLOW_Acceptance_TestData[] =
{
        /************/
        /*        static FLOW vectors         */
        /************/
	#if TST_USE_FLOW_AES_ECBMode_DATA
     { 
        {"Acceptance flow test - AES/ECB/128Key/512ByteData "},
        /* input interrupt id */
        0,
    
        /* output interrupt id */
        1,
  
        /* if the data in the buffers are in words and not bytes */ 
        0,
  
        /* number of input buffers */
        4,
    
        /* flag if  endian order of the input buffers is big */
        0,
  
        /* number of output buffers */
        4,
        0,
        /* TST_Expected_output_data */
        {
            0x3C,0x42,0xBD,0x48,0x63,0xDA,0xD0,0xBA,0x19,0x18,0x22,0x50,0xD7,0x68,0x69,0x31,
            0xB7,0xF8,0xA7,0x5C,0xF1,0x5D,0xA9,0x04,0x33,0x72,0x8B,0x41,0xAB,0x76,0x6F,0xFB,
            0xCA,0x94,0x72,0xF3,0xA3,0x0C,0xC6,0x45,0x92,0x89,0x07,0x09,0xA5,0x1D,0xAE,0x22,
            0x65,0x1F,0x6A,0x76,0x30,0x11,0xBB,0x7C,0x28,0xB7,0x92,0x51,0x58,0xEE,0x6F,0x29,
            0x42,0x53,0xF7,0xB5,0x45,0xEB,0xC1,0x36,0xE1,0x9B,0xE0,0xDF,0x80,0x87,0xC4,0x95,
            0x60,0x2E,0x61,0x8F,0xF1,0xB7,0xD6,0x65,0x32,0x0E,0x43,0xDD,0x3A,0x1E,0x9F,0x63,
            0x81,0xF9,0xE1,0xC0,0xE0,0x0E,0x19,0xB1,0xEC,0xB9,0xDB,0xDE,0x0C,0x58,0x9F,0xA3,
            0xFD,0x58,0xAD,0x12,0xE2,0xC8,0xD5,0x5B,0x51,0x9E,0xAA,0xF2,0x64,0x52,0xDE,0xFE,
            0x92,0x59,0xCD,0x7F,0xD9,0x33,0x60,0xF7,0xE0,0xD4,0xE4,0x2B,0xD0,0x8E,0xB8,0x3F,
            0xE4,0x49,0x41,0x23,0xB9,0xF0,0xD3,0xCE,0x7B,0x6E,0x1C,0xF2,0x85,0x65,0xED,0x73,
            0x29,0x24,0x4D,0x88,0xE3,0x0E,0x56,0xD3,0xA7,0xC2,0x4F,0x4A,0x51,0x0A,0xB1,0xCB,
            0xAB,0x6C,0x56,0xD3,0xBC,0xCA,0xCC,0x9E,0x5E,0x58,0xE0,0x2D,0x9C,0x14,0x8A,0xDD,
            0x4F,0x47,0xD4,0xE9,0x2D,0x8D,0x64,0xA1,0xA8,0xED,0x96,0xB2,0x3F,0x7F,0x64,0x6D,
            0x6E,0x20,0xE7,0x66,0x7D,0xEF,0x13,0x5F,0xCB,0x14,0x40,0x09,0x31,0x58,0x90,0xC7,
            0x5B,0x3C,0xA6,0x5F,0x8A,0x2B,0xA6,0x6B,0x84,0xC7,0xF4,0x38,0x8A,0x37,0xEF,0xF4,
            0xC5,0x65,0x56,0xC6,0x67,0x36,0x27,0x50,0x9F,0x91,0x35,0xE4,0x43,0x50,0x87,0x0F,
            0x8C,0x9F,0x3B,0x87,0x28,0xDB,0x23,0x5F,0xD4,0xC0,0xDB,0x85,0xBA,0x2A,0x4C,0x7D,
            0xD4,0x11,0x8F,0xC1,0xEE,0x30,0x7A,0xD2,0x38,0x74,0x1B,0xD1,0x06,0x61,0x59,0x75,
            0x54,0x1A,0xCE,0x93,0x1A,0x3D,0x3B,0x08,0xD1,0x35,0xF8,0x02,0xBC,0x19,0x1E,0x63,
            0xF7,0x63,0x70,0x4A,0xEE,0x79,0xA6,0x27,0x0A,0xF8,0x75,0x83,0x21,0x6B,0x60,0x27,
            0x2F,0xC5,0x56,0xB2,0x4E,0x05,0xA2,0xBA,0x87,0xC6,0x08,0xA1,0xF9,0x12,0x74,0x73,
            0x2E,0xF4,0xF1,0xB8,0x25,0x58,0x36,0xDF,0xA5,0x9D,0xF4,0xAE,0x22,0x44,0xE2,0x9C,
            0x3F,0xDB,0xC9,0x65,0xD6,0x53,0x38,0xDA,0x95,0x90,0xF4,0x67,0xF1,0xD5,0xD9,0xCC,
            0x88,0xA6,0x03,0xBC,0x5D,0xA3,0xFA,0xB6,0x59,0x0F,0x1C,0x82,0x73,0xAB,0xEF,0xE0,
            0x8E,0x10,0x45,0x10,0x30,0xAD,0x7B,0xEF,0x63,0x1D,0x71,0xBB,0x87,0x29,0x8D,0xC8,
            0xE6,0xB4,0x07,0xA0,0xFD,0x11,0xF8,0x52,0x1B,0xE1,0x9B,0x6B,0x61,0xB8,0x99,0xF8,
            0x23,0xA2,0x46,0x2D,0x22,0xCA,0x34,0x42,0x92,0xEF,0x57,0xB5,0xA7,0xA3,0x38,0xCC,
            0xAD,0x8D,0xC3,0x47,0x3E,0x3E,0xB5,0x49,0x99,0x5D,0x21,0x13,0xDD,0x9A,0xE3,0xB3,
            0x0E,0x47,0x0B,0xED,0x93,0xC8,0x35,0x62,0x4A,0x27,0x90,0x5B,0xC7,0xD7,0xD9,0xE4,
            0x45,0x99,0x95,0x71,0x4A,0xB6,0xE3,0x37,0x87,0x1B,0x25,0xE0,0x9D,0x94,0x9C,0x6D,
            0xAD,0x1C,0x94,0xB6,0x7F,0x5B,0xA4,0x28,0xCB,0xB6,0xA0,0xDD,0xD2,0xC5,0x42,0xE4,
            0x67,0x35,0x71,0x5C,0xE9,0x0B,0xAB,0x5A,0x13,0x9E,0xF2,0x8F,0x61,0x6A,0x3B,0x64
        },
        /* TST_Expected_cyclicOperation_data */
        {
            0x3C,0x42,0xBD,0x48,0x63,0xDA,0xD0,0xBA,0x19,0x18,0x22,0x50,0xD7,0x68,0x69,0x31,
            0xB7,0xF8,0xA7,0x5C,0xF1,0x5D,0xA9,0x04,0x33,0x72,0x8B,0x41,0xAB,0x76,0x6F,0xFB,
            0xCA,0x94,0x72,0xF3,0xA3,0x0C,0xC6,0x45,0x92,0x89,0x07,0x09,0xA5,0x1D,0xAE,0x22,
            0x65,0x1F,0x6A,0x76,0x30,0x11,0xBB,0x7C,0x28,0xB7,0x92,0x51,0x58,0xEE,0x6F,0x29,
            0x42,0x53,0xF7,0xB5,0x45,0xEB,0xC1,0x36,0xE1,0x9B,0xE0,0xDF,0x80,0x87,0xC4,0x95,
            0x60,0x2E,0x61,0x8F,0xF1,0xB7,0xD6,0x65,0x32,0x0E,0x43,0xDD,0x3A,0x1E,0x9F,0x63,
            0x81,0xF9,0xE1,0xC0,0xE0,0x0E,0x19,0xB1,0xEC,0xB9,0xDB,0xDE,0x0C,0x58,0x9F,0xA3,
            0xFD,0x58,0xAD,0x12,0xE2,0xC8,0xD5,0x5B,0x51,0x9E,0xAA,0xF2,0x64,0x52,0xDE,0xFE,
            0x92,0x59,0xCD,0x7F,0xD9,0x33,0x60,0xF7,0xE0,0xD4,0xE4,0x2B,0xD0,0x8E,0xB8,0x3F,
            0xE4,0x49,0x41,0x23,0xB9,0xF0,0xD3,0xCE,0x7B,0x6E,0x1C,0xF2,0x85,0x65,0xED,0x73,
            0x29,0x24,0x4D,0x88,0xE3,0x0E,0x56,0xD3,0xA7,0xC2,0x4F,0x4A,0x51,0x0A,0xB1,0xCB,
            0xAB,0x6C,0x56,0xD3,0xBC,0xCA,0xCC,0x9E,0x5E,0x58,0xE0,0x2D,0x9C,0x14,0x8A,0xDD,
            0x4F,0x47,0xD4,0xE9,0x2D,0x8D,0x64,0xA1,0xA8,0xED,0x96,0xB2,0x3F,0x7F,0x64,0x6D,
            0x6E,0x20,0xE7,0x66,0x7D,0xEF,0x13,0x5F,0xCB,0x14,0x40,0x09,0x31,0x58,0x90,0xC7,
            0x5B,0x3C,0xA6,0x5F,0x8A,0x2B,0xA6,0x6B,0x84,0xC7,0xF4,0x38,0x8A,0x37,0xEF,0xF4,
            0xC5,0x65,0x56,0xC6,0x67,0x36,0x27,0x50,0x9F,0x91,0x35,0xE4,0x43,0x50,0x87,0x0F,
            0x3C,0x42,0xBD,0x48,0x63,0xDA,0xD0,0xBA,0x19,0x18,0x22,0x50,0xD7,0x68,0x69,0x31,
            0xB7,0xF8,0xA7,0x5C,0xF1,0x5D,0xA9,0x04,0x33,0x72,0x8B,0x41,0xAB,0x76,0x6F,0xFB,
            0xCA,0x94,0x72,0xF3,0xA3,0x0C,0xC6,0x45,0x92,0x89,0x07,0x09,0xA5,0x1D,0xAE,0x22,
            0x65,0x1F,0x6A,0x76,0x30,0x11,0xBB,0x7C,0x28,0xB7,0x92,0x51,0x58,0xEE,0x6F,0x29,
            0x42,0x53,0xF7,0xB5,0x45,0xEB,0xC1,0x36,0xE1,0x9B,0xE0,0xDF,0x80,0x87,0xC4,0x95,
            0x60,0x2E,0x61,0x8F,0xF1,0xB7,0xD6,0x65,0x32,0x0E,0x43,0xDD,0x3A,0x1E,0x9F,0x63,
            0x81,0xF9,0xE1,0xC0,0xE0,0x0E,0x19,0xB1,0xEC,0xB9,0xDB,0xDE,0x0C,0x58,0x9F,0xA3,
            0xFD,0x58,0xAD,0x12,0xE2,0xC8,0xD5,0x5B,0x51,0x9E,0xAA,0xF2,0x64,0x52,0xDE,0xFE,
            0x92,0x59,0xCD,0x7F,0xD9,0x33,0x60,0xF7,0xE0,0xD4,0xE4,0x2B,0xD0,0x8E,0xB8,0x3F,
            0xE4,0x49,0x41,0x23,0xB9,0xF0,0xD3,0xCE,0x7B,0x6E,0x1C,0xF2,0x85,0x65,0xED,0x73,
            0x29,0x24,0x4D,0x88,0xE3,0x0E,0x56,0xD3,0xA7,0xC2,0x4F,0x4A,0x51,0x0A,0xB1,0xCB,
            0xAB,0x6C,0x56,0xD3,0xBC,0xCA,0xCC,0x9E,0x5E,0x58,0xE0,0x2D,0x9C,0x14,0x8A,0xDD,
            0x4F,0x47,0xD4,0xE9,0x2D,0x8D,0x64,0xA1,0xA8,0xED,0x96,0xB2,0x3F,0x7F,0x64,0x6D,
            0x6E,0x20,0xE7,0x66,0x7D,0xEF,0x13,0x5F,0xCB,0x14,0x40,0x09,0x31,0x58,0x90,0xC7,
            0x5B,0x3C,0xA6,0x5F,0x8A,0x2B,0xA6,0x6B,0x84,0xC7,0xF4,0x38,0x8A,0x37,0xEF,0xF4,
            0xC5,0x65,0x56,0xC6,0x67,0x36,0x27,0x50,0x9F,0x91,0x35,0xE4,0x43,0x50,0x87,0x0F
        },
        /*TST_Key*/
        {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0},
        CRYS_AES_ECB_mode,
    },
	#endif
	#if TST_USE_FLOW_AES_CBCMode_DATA
	 { 
		 {"Acceptance flow test - AES/CBC/128Key/512ByteData "},
			 /* input interrupt id */
			 0,

			 /* output interrupt id */
			 1,

			 /* if the data in the buffers are in words and not bytes */ 
			 0,

			 /* number of input buffers */
			 4,
			 /* flag if  endian order of the input buffers is big */
			 0,

			 /* number of output buffers */
			 4,
			 0,
			 /* TST_Expected_output_data */
		 {
			 0x1E,0xB7,0xDC,0x51,0xC6,0x39,0x66,0x6A,0x7C,0xFC,0xDF,0xEF,0x3F,0x68,0x0B,0xDC,
			 0x84,0xF0,0xCD,0x30,0x43,0x38,0xC3,0xE0,0x7A,0xF8,0x22,0x8F,0x8B,0x5A,0x27,0xD5,
			 0x29,0x3E,0x50,0xCC,0x64,0x12,0x67,0x82,0x2F,0x84,0x4D,0xB4,0x4C,0x22,0x3F,0xF2,
			 0x4B,0x96,0xBC,0xA3,0x29,0x34,0xA9,0xB8,0x3D,0x91,0x48,0x06,0xEC,0x9B,0x05,0x19,
			 0x46,0xBD,0x82,0xD8,0x44,0x7D,0x64,0x6D,0xFB,0x34,0x38,0x13,0x6E,0x51,0x61,0xBD,
			 0xB6,0xD2,0x40,0x87,0xEF,0x8B,0x0D,0x38,0x94,0x3A,0x5A,0xA3,0xC9,0x17,0x7D,0xA4,
			 0x67,0x1D,0xFF,0xF8,0xD1,0xC5,0x15,0x97,0xC5,0x57,0xE8,0x0E,0xDE,0xA7,0x8F,0xF5,
			 0x73,0x47,0x66,0xFF,0x5A,0x6C,0xF4,0x66,0x95,0x56,0x11,0x23,0x71,0x33,0x21,0xCC,
			 0x03,0x47,0x0C,0x64,0xBC,0x9E,0x29,0xF2,0x77,0x49,0x38,0xB7,0x5B,0xF5,0x3F,0x0D,
			 0xC7,0x1F,0x71,0x72,0x78,0x5B,0xE6,0x82,0x38,0x38,0xB3,0x49,0xC5,0x45,0xCA,0xEA,
			 0x86,0xB4,0xF6,0x88,0x24,0xB2,0x37,0x07,0x8B,0xAD,0xBE,0xA9,0x80,0x18,0x60,0xCF,
			 0x77,0x35,0x35,0x65,0x6F,0x66,0xBE,0xD0,0x7C,0x85,0x46,0x3E,0x68,0x5A,0x92,0x43,
			 0x81,0x2B,0xED,0xCF,0x05,0xC7,0x4A,0x28,0xDB,0x83,0x7A,0x17,0x17,0xD0,0x31,0x0E,
			 0x94,0xB3,0xA9,0xE6,0x47,0x8E,0x4E,0x07,0x6F,0x01,0x69,0x83,0xA2,0xEF,0x9E,0x74,
			 0x9C,0x47,0x45,0x31,0x30,0xD4,0xF8,0xC8,0x69,0xC4,0xCD,0xA6,0x55,0xBC,0x9A,0x41,
			 0xB4,0xE2,0x2A,0x36,0xF4,0x1E,0x1F,0xE3,0x18,0xD5,0x2F,0x07,0x99,0xB9,0x92,0x8D,
			 0xC5,0x49,0xDB,0x1D,0xED,0x3C,0x4D,0x44,0x8F,0x35,0xE0,0x3C,0xB5,0x66,0x09,0xA3,
			 0xEE,0x68,0x17,0x7B,0x47,0xCA,0x7F,0x79,0x7D,0x2B,0xD6,0xBB,0xBB,0x44,0x17,0xD0,
			 0xE0,0xFF,0x09,0x3C,0x6F,0xBC,0x19,0xAC,0xE5,0x61,0x49,0x32,0xBD,0xCC,0x6D,0x8A,
			 0x45,0xCB,0x69,0x32,0x17,0xBB,0x93,0x80,0xA2,0x21,0x83,0xF1,0x42,0xC8,0x15,0xAC,
			 0xB9,0xDE,0xBB,0x58,0xF2,0x2E,0x09,0xDD,0xBE,0xE2,0x7F,0x51,0x03,0x15,0xA6,0x6E,
			 0x6B,0xA0,0x2C,0x32,0x7A,0x80,0x61,0x0E,0x9C,0xF8,0xC8,0xF5,0x84,0xFB,0x24,0xC4,
			 0x07,0x67,0x63,0x0B,0x33,0x89,0xF0,0x6A,0x3B,0x44,0x67,0xBA,0x79,0x5D,0xEC,0xDE,
			 0xE5,0x33,0x70,0xA1,0x22,0x2B,0x8A,0x30,0x3D,0xE4,0xA2,0x85,0xA4,0x92,0x26,0xA0,
			 0x7C,0x8B,0x4F,0x58,0xE5,0xB2,0x36,0x22,0x76,0x4E,0x34,0xF7,0xBE,0x04,0x2A,0x2A,
			 0x60,0xDA,0x2E,0x58,0x5B,0xAB,0xC9,0xD5,0x0C,0x0E,0x44,0xC9,0x5D,0xB3,0x9C,0xB8,
			 0x14,0x5B,0xF9,0x63,0x86,0xF8,0xED,0x87,0x3D,0x3F,0xCB,0xEC,0xDA,0x15,0xEB,0xDE,
			 0x3C,0x7A,0xDB,0x65,0x07,0x78,0xBC,0xD5,0x6B,0x56,0xA9,0x06,0x4E,0x86,0x59,0xA8,
			 0x7F,0xE3,0xB7,0x2D,0x43,0x9A,0x3F,0xDA,0x30,0x43,0xBE,0xB5,0x38,0x95,0xA2,0x28,
			 0x71,0x64,0x47,0x3F,0x78,0x7E,0x29,0x6E,0x7E,0xEE,0x0E,0x13,0xB2,0x37,0x25,0xC1,
			 0xE6,0x01,0xBF,0xB0,0xFB,0x37,0x02,0xEC,0x6C,0x83,0x05,0xAB,0x21,0x36,0x79,0xA9,
			 0x85,0x68,0x83,0x8A,0xCA,0xDE,0xFE,0x2E,0x0E,0x89,0x3E,0x16,0x4B,0x5C,0x2E,0x98
		 },
		 /* TST_Expected_cyclicOperation_data */
		 {
		    0x1E,0xB7,0xDC,0x51,0xC6,0x39,0x66,0x6A,0x7C,0xFC,0xDF,0xEF,0x3F,0x68,0x0B,0xDC,
            0x84,0xF0,0xCD,0x30,0x43,0x38,0xC3,0xE0,0x7A,0xF8,0x22,0x8F,0x8B,0x5A,0x27,0xD5,
            0x29,0x3E,0x50,0xCC,0x64,0x12,0x67,0x82,0x2F,0x84,0x4D,0xB4,0x4C,0x22,0x3F,0xF2,
            0x4B,0x96,0xBC,0xA3,0x29,0x34,0xA9,0xB8,0x3D,0x91,0x48,0x06,0xEC,0x9B,0x05,0x19,
            0x46,0xBD,0x82,0xD8,0x44,0x7D,0x64,0x6D,0xFB,0x34,0x38,0x13,0x6E,0x51,0x61,0xBD,
            0xB6,0xD2,0x40,0x87,0xEF,0x8B,0x0D,0x38,0x94,0x3A,0x5A,0xA3,0xC9,0x17,0x7D,0xA4,
            0x67,0x1D,0xFF,0xF8,0xD1,0xC5,0x15,0x97,0xC5,0x57,0xE8,0x0E,0xDE,0xA7,0x8F,0xF5,
            0x73,0x47,0x66,0xFF,0x5A,0x6C,0xF4,0x66,0x95,0x56,0x11,0x23,0x71,0x33,0x21,0xCC,
            0x03,0x47,0x0C,0x64,0xBC,0x9E,0x29,0xF2,0x77,0x49,0x38,0xB7,0x5B,0xF5,0x3F,0x0D,
            0xC7,0x1F,0x71,0x72,0x78,0x5B,0xE6,0x82,0x38,0x38,0xB3,0x49,0xC5,0x45,0xCA,0xEA,
            0x86,0xB4,0xF6,0x88,0x24,0xB2,0x37,0x07,0x8B,0xAD,0xBE,0xA9,0x80,0x18,0x60,0xCF,
            0x77,0x35,0x35,0x65,0x6F,0x66,0xBE,0xD0,0x7C,0x85,0x46,0x3E,0x68,0x5A,0x92,0x43,
            0x81,0x2B,0xED,0xCF,0x05,0xC7,0x4A,0x28,0xDB,0x83,0x7A,0x17,0x17,0xD0,0x31,0x0E,
            0x94,0xB3,0xA9,0xE6,0x47,0x8E,0x4E,0x07,0x6F,0x01,0x69,0x83,0xA2,0xEF,0x9E,0x74,
            0x9C,0x47,0x45,0x31,0x30,0xD4,0xF8,0xC8,0x69,0xC4,0xCD,0xA6,0x55,0xBC,0x9A,0x41,
            0xB4,0xE2,0x2A,0x36,0xF4,0x1E,0x1F,0xE3,0x18,0xD5,0x2F,0x07,0x99,0xB9,0x92,0x8D,
            0x73,0xE2,0xBA,0x34,0xA4,0xD1,0x7E,0xFD,0xA5,0x00,0xAB,0x75,0xB1,0x7C,0x31,0xB6,
            0xDD,0x67,0x95,0x9C,0x00,0x97,0x69,0x0A,0xC4,0xEE,0xB5,0x8A,0xEF,0x16,0x52,0x81,
            0x87,0x14,0xBC,0x70,0xC8,0xBD,0x18,0xEB,0xA9,0x11,0x35,0x09,0x68,0x58,0x0F,0x26,
            0xA6,0x89,0xE0,0x8D,0xC6,0x6E,0xDD,0xD2,0x89,0xC3,0x3E,0x8D,0xA1,0xBA,0xD0,0xDE,
            0xAA,0xFB,0xC1,0x3B,0x6B,0xBD,0x3B,0x17,0x18,0xF3,0xC8,0x83,0xC0,0x2A,0xA7,0x85,
            0x60,0x4C,0xFB,0x9D,0x22,0x4D,0x3C,0xE1,0xFD,0x31,0xF6,0x38,0xC3,0x63,0x0D,0x3A,
            0xCB,0x37,0xA9,0xD4,0x07,0x7A,0x37,0x10,0x9E,0xAC,0x30,0xA6,0xA8,0x4B,0x2B,0xF6,
            0xE5,0xA4,0x96,0x43,0x40,0xD6,0x9B,0xDA,0x9D,0xCE,0xD3,0x34,0x43,0x1A,0x08,0x4F,
            0xF1,0xF2,0xCF,0xFC,0xCC,0x87,0x03,0xF0,0xCD,0xEC,0xEB,0xCB,0x4E,0x08,0x9C,0x24,
            0x51,0xD8,0x34,0x56,0x56,0xC2,0xD3,0xA8,0xF9,0xC0,0x22,0x4D,0x34,0x53,0xEA,0x8F,
            0x89,0xBC,0xAD,0x3C,0x7E,0x0A,0x9D,0x1A,0x17,0x82,0x85,0xEE,0x31,0x98,0xAA,0x5F,
            0x09,0x01,0x4B,0xBD,0xF9,0xC0,0x00,0x7D,0xD6,0x28,0x4E,0x42,0xA4,0x2F,0xA2,0x36,
            0xDE,0x16,0x45,0x28,0x94,0xDF,0x32,0x22,0x7B,0x16,0x21,0x5E,0xA7,0x9B,0x1F,0x8A,
            0xEB,0x66,0xC0,0xF7,0xE4,0x70,0x77,0x6C,0xA4,0xC9,0xC5,0xC4,0xBC,0x41,0xF4,0xA5,
            0x94,0x18,0x43,0x79,0x5D,0xEA,0xD0,0x84,0x36,0xB5,0x95,0xC2,0x89,0xAC,0xD4,0xFC,
            0x8C,0x41,0x0D,0x1E,0x0B,0xA1,0xBF,0xF3,0x79,0x68,0xF6,0xAC,0x53,0x1B,0x4C,0x77
		 },
		 /*TST_Key*/
		 {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
		 CRYS_AES_Key128BitSize,
		 /*TST_IvCounter*/
		{0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
		CRYS_AES_CBC_mode,
		
	},
	#endif
	#if TST_USE_FLOW_AES_MACMode_DATA
	{ 
		{"Acceptance  flow test - AES/MAC/128Key/512ByteData "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4,
			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x85,0x68,0x83,0x8A,0xCA,0xDE,0xFE,0x2E,0x0E,0x89,0x3E,0x16,0x4B,0x5C,0x2E,0x98
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0x8C,0x41,0x0D,0x1E,0x0B,0xA1,0xBF,0xF3,0x79,0x68,0xF6,0xAC,0x53,0x1B,0x4C,0x77
		 },
		/*TST_Key*/
		{0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
		CRYS_AES_Key128BitSize,
		/*TST_IvCounter*/
		{0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
		CRYS_AES_MAC_mode,

	 },
	#endif
	#if TST_USE_FLOW_AES_CTRMode_DATA
	 { 
		 {"Acceptance  flow test - AES/CTR/128Key/512ByteData "},
			 /* input interrupt id */
			 0,

			 /* output interrupt id */
			 1,

			 /* if the data in the buffers are in words and not bytes */ 
			 0,

			 /* number of input buffers */
			 8,
			 /* flag if  endian order of the input buffers is big */
			 0,

			 /* number of output buffers */
			 8,
			 0,
			 /* TST_Expected_output_data */
		 {
			 0x18,0xD8,0x8F,0x5D,0xE5,0x5F,0x08,0xA4,0x4F,0x9E,0x27,0x76,0x92,0x49,0x1F,0x16,
			 0x23,0x68,0x7A,0x88,0xCD,0x85,0x94,0x4A,0xF4,0x52,0x4F,0x79,0xEC,0xBA,0x7E,0x87,
			 0x34,0xA5,0xC9,0x5A,0xB5,0x7C,0xAE,0x4D,0x91,0xD1,0x62,0xD7,0xA7,0xC5,0x4B,0xC4,
			 0x49,0x65,0x3E,0x79,0x5E,0x05,0xD8,0x90,0xE5,0xD6,0x6D,0xD7,0xCD,0x7F,0x2E,0x00,
			 0xDD,0x97,0x90,0xCF,0x54,0x2B,0x00,0xCA,0x46,0xF9,0x8A,0x26,0xCA,0x83,0x6E,0x63,
			 0xE2,0x18,0xE8,0x7F,0xDD,0x2A,0xD5,0x9E,0xF9,0x7D,0xBE,0x0E,0xA4,0xF2,0x27,0x9A,
			 0x8B,0xAC,0x0C,0x20,0xCD,0xD7,0x5C,0x38,0x77,0xBB,0x9E,0xFE,0xCE,0x7A,0x27,0x18,
			 0x3E,0x18,0x5D,0xA3,0x08,0x5D,0x3E,0xA1,0x3C,0x8B,0xB4,0x1B,0x73,0x41,0xD8,0x76,
			 0xB9,0x50,0xC5,0xDB,0xB2,0x08,0x4B,0xFF,0xAA,0x9F,0x58,0x68,0xC8,0x6C,0x7B,0xD8,
			 0xF4,0xA7,0x31,0x8D,0xF7,0x51,0xEC,0xE7,0x39,0x6D,0x64,0xFF,0xF9,0x0B,0x0A,0xA8,
			 0x35,0xC8,0xA2,0xB7,0xAF,0x9D,0x96,0xE0,0x2D,0x37,0xA7,0x91,0x9D,0x23,0x71,0xA8,
			 0x35,0xF4,0x3E,0x8E,0x90,0xD0,0x41,0x5B,0x60,0x55,0xCD,0x4F,0xCC,0x76,0xEA,0xF4,
			 0x82,0x39,0xC1,0xA4,0x81,0x54,0x60,0x86,0x64,0x14,0xA8,0xE5,0x06,0x01,0x0E,0x41,
			 0x15,0x6D,0xC2,0xDD,0xF6,0x95,0x57,0x2F,0x7A,0x12,0x14,0x60,0xFD,0x1C,0xF6,0xD5,
			 0x8D,0x04,0x4B,0x75,0xB5,0xD1,0x39,0xD8,0x97,0x3F,0xF7,0xC8,0x39,0x1F,0x76,0x27,
			 0xCC,0xAF,0x2D,0xD9,0x72,0xF1,0x03,0xFE,0x77,0xAE,0xDE,0x3C,0x97,0x9F,0x61,0x8B,
			 0xA7,0x10,0x5F,0xA5,0x65,0x19,0x19,0xFE,0x14,0x18,0x6E,0x76,0xA6,0xAE,0x49,0x1C,
			 0x1C,0x18,0x91,0xED,0x69,0x20,0x0D,0xF7,0xCD,0xD5,0xEE,0x70,0x4D,0x60,0xAE,0x6C,
			 0x30,0x26,0x98,0x95,0x92,0x14,0x9A,0x7C,0xF4,0xFF,0x1E,0x95,0xB4,0xBF,0x43,0x2F,
			 0x99,0x82,0xAB,0x4D,0xB0,0x42,0x46,0x7A,0xEB,0xA5,0x99,0x06,0x56,0x47,0xA3,0x8E,
			 0xE3,0x61,0x05,0x8F,0x51,0xE1,0xB7,0x9A,0xA2,0x4B,0x35,0x2A,0x47,0xCD,0x4D,0x92,
			 0x8C,0x4B,0x0B,0x6D,0x2B,0x64,0x8B,0x36,0x74,0x05,0x45,0x72,0xE6,0xA5,0x56,0x35,
			 0x80,0x99,0x04,0x86,0x83,0xDE,0x57,0xB1,0x99,0xAE,0x8B,0xFB,0xBC,0xAD,0xB5,0x65,
			 0xAB,0xA4,0x0D,0x99,0x9F,0x04,0xA4,0x31,0xC8,0xF3,0xD4,0x2D,0x48,0x93,0xB5,0x4C,
			 0x38,0xFD,0x8C,0x41,0x40,0xBC,0x7C,0x13,0x07,0x94,0x04,0xA4,0x2B,0xA9,0x1F,0x74,
			 0xAA,0x1A,0xF1,0x50,0x37,0x7B,0x7A,0xD9,0x67,0x6A,0x3E,0x51,0xCD,0xEC,0x7F,0xEB,
			 0x6B,0x9E,0x40,0x47,0xB6,0x2B,0xF0,0x9E,0x90,0xEC,0x00,0x90,0x92,0xC6,0xB5,0x33,
			 0x26,0xF5,0x34,0x8F,0x2C,0x9E,0xF8,0xD8,0x6B,0xB2,0x51,0x19,0xB9,0xA6,0x9F,0xF1,
			 0x1B,0xA9,0x97,0x60,0x12,0xB6,0x48,0xB8,0x80,0x3A,0x1F,0x56,0x38,0x81,0x36,0x9A,
			 0xDF,0x1E,0xF5,0xB8,0xFE,0x9E,0x9C,0x95,0x77,0x71,0xDA,0x16,0x9E,0xCA,0x50,0x82,
			 0xDC,0xBD,0x4E,0xDB,0x25,0xB4,0xA7,0x9F,0xA3,0x2A,0x6A,0xE7,0x83,0xBD,0xA8,0x28,
			 0x37,0x93,0x6C,0xEE,0x54,0x18,0x5D,0x5D,0x49,0x3C,0x47,0x5F,0x3E,0xF2,0x8B,0x1D
		 },
		 {
		    0x18,0xD8,0x8F,0x5D,0xE5,0x5F,0x08,0xA4,0x4F,0x9E,0x27,0x76,0x92,0x49,0x1F,0x16,
            0x23,0x68,0x7A,0x88,0xCD,0x85,0x94,0x4A,0xF4,0x52,0x4F,0x79,0xEC,0xBA,0x7E,0x87,
            0x34,0xA5,0xC9,0x5A,0xB5,0x7C,0xAE,0x4D,0x91,0xD1,0x62,0xD7,0xA7,0xC5,0x4B,0xC4,
            0x49,0x65,0x3E,0x79,0x5E,0x05,0xD8,0x90,0xE5,0xD6,0x6D,0xD7,0xCD,0x7F,0x2E,0x00,
            0xDD,0x97,0x90,0xCF,0x54,0x2B,0x00,0xCA,0x46,0xF9,0x8A,0x26,0xCA,0x83,0x6E,0x63,
            0xE2,0x18,0xE8,0x7F,0xDD,0x2A,0xD5,0x9E,0xF9,0x7D,0xBE,0x0E,0xA4,0xF2,0x27,0x9A,
            0x8B,0xAC,0x0C,0x20,0xCD,0xD7,0x5C,0x38,0x77,0xBB,0x9E,0xFE,0xCE,0x7A,0x27,0x18,
            0x3E,0x18,0x5D,0xA3,0x08,0x5D,0x3E,0xA1,0x3C,0x8B,0xB4,0x1B,0x73,0x41,0xD8,0x76,
            0xB9,0x50,0xC5,0xDB,0xB2,0x08,0x4B,0xFF,0xAA,0x9F,0x58,0x68,0xC8,0x6C,0x7B,0xD8,
            0xF4,0xA7,0x31,0x8D,0xF7,0x51,0xEC,0xE7,0x39,0x6D,0x64,0xFF,0xF9,0x0B,0x0A,0xA8,
            0x35,0xC8,0xA2,0xB7,0xAF,0x9D,0x96,0xE0,0x2D,0x37,0xA7,0x91,0x9D,0x23,0x71,0xA8,
            0x35,0xF4,0x3E,0x8E,0x90,0xD0,0x41,0x5B,0x60,0x55,0xCD,0x4F,0xCC,0x76,0xEA,0xF4,
            0x82,0x39,0xC1,0xA4,0x81,0x54,0x60,0x86,0x64,0x14,0xA8,0xE5,0x06,0x01,0x0E,0x41,
            0x15,0x6D,0xC2,0xDD,0xF6,0x95,0x57,0x2F,0x7A,0x12,0x14,0x60,0xFD,0x1C,0xF6,0xD5,
            0x8D,0x04,0x4B,0x75,0xB5,0xD1,0x39,0xD8,0x97,0x3F,0xF7,0xC8,0x39,0x1F,0x76,0x27,
            0xCC,0xAF,0x2D,0xD9,0x72,0xF1,0x03,0xFE,0x77,0xAE,0xDE,0x3C,0x97,0x9F,0x61,0x8B,
            0x43,0x0E,0xFA,0x9C,0xF5,0x74,0x71,0xE2,0x52,0x77,0x5A,0x7E,0x45,0x30,0x3E,0x84,
            0xF8,0x97,0x39,0xD2,0x34,0xE4,0xEC,0x1E,0x8E,0xFC,0x4F,0xEA,0x03,0x82,0x16,0x32,
            0x95,0x39,0x1D,0x01,0x58,0x88,0xD0,0x1D,0xA4,0x48,0x9B,0xB9,0x7C,0xBC,0x5B,0xB3,
            0x58,0xAB,0x8A,0x26,0x08,0x47,0xA0,0x91,0xFA,0x2A,0xBC,0x29,0x92,0x54,0x6B,0x9D,
            0x9B,0x56,0xD6,0xFF,0x1C,0x3A,0x02,0x04,0xCF,0xCF,0x93,0x49,0x10,0x3C,0x46,0x22,
            0x2A,0x4B,0xE0,0x77,0x06,0xE1,0x6F,0x06,0x10,0xCD,0x31,0x73,0x78,0x65,0x00,0x70,
            0x15,0xFD,0x6C,0xCA,0x7C,0x6B,0x60,0x07,0xC6,0xEA,0x12,0xD6,0xC8,0xCD,0x7A,0x40,
            0xEF,0x9C,0x06,0x7C,0x48,0xC6,0x82,0xFA,0x3F,0x10,0xAB,0x71,0x57,0xC3,0x11,0x35,
            0x66,0x98,0xCB,0x88,0x66,0x8A,0x0F,0x00,0x1C,0xE7,0x16,0x6E,0xF2,0x99,0xE3,0x5E,
            0x4C,0x95,0xF0,0x51,0xCC,0xBD,0x03,0xA0,0x68,0x23,0x27,0xC9,0x79,0x4C,0xAA,0x37,
            0x3B,0xE5,0x1D,0x5C,0x8A,0xA1,0x00,0x22,0xBA,0x97,0xBC,0xC9,0xCD,0x05,0xDB,0xC5,
            0x7F,0xEF,0x6C,0x2A,0xCE,0x1D,0xD0,0xC6,0xA0,0x7C,0x91,0xDD,0xE0,0x75,0x9D,0x32,
            0x8D,0x3B,0x3A,0x67,0x21,0xDF,0xFB,0x10,0x15,0xDF,0x9B,0x6B,0xE4,0x90,0x71,0x99,
            0x33,0xFD,0xA4,0xA0,0xEA,0x99,0x26,0x17,0x85,0xD8,0x14,0x47,0xBE,0xC8,0x60,0x2F,
            0x29,0x87,0x0C,0x19,0x7E,0x3B,0x50,0x63,0xA3,0xD0,0xC4,0x80,0x29,0x9E,0x39,0x5F,
            0xE9,0xA9,0xF7,0xD3,0xDD,0xD8,0xF0,0x14,0xE9,0xFE,0x78,0x3C,0x9B,0x60,0x29,0xA3
		 },
		 /*TST_Key*/
		 {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
		 CRYS_AES_Key128BitSize,
		 /*TST_IvCounter*/
		{0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
		CRYS_AES_CTR_mode,

	},
	#endif   
	#if TST_USE_FLOW_AES_XCBCMACMode_DATA
	{ 
		{"Acceptance  flow test - AES/XCBCMAC/128Key/512ByteData "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4,
			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0xBC,0x01,0xFA,0x30,0xA9,0x16,0xA3,0x5F,0x7B,0x3A,0xCA,0xC2,0x58,0xC6,0xD1,0x87
		},
		{
		    0x3B,0x17,0xAA,0x2C,0x47,0x5D,0x4D,0x9B,0x58,0xA6,0xAB,0xAB,0x91,0xAE,0x0E,0x96
		},
		/*TST_Key*/
		{0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
		CRYS_AES_Key128BitSize,
		/*TST_IvCounter*/
		{0},
		CRYS_AES_XCBC_MAC_mode,

	 },
	#endif   
	#if TST_USE_FLOW_AES_CMACMode_DATA
	 { 
		 {"Acceptance  flow test - AES/CMAC/128Key/512ByteData "},
			 /* input interrupt id */
			 0,

			 /* output interrupt id */
			 1,

			 /* if the data in the buffers are in words and not bytes */ 
			 0,

			 /* number of input buffers */
			 4,
			 /* flag if  endian order of the input buffers is big */
			 0,

			 /* number of output buffers */
			 0,
			 0,
			 /* TST_Expected_output_data */
		 {
			 0x53,0x0B,0xE4,0xA4,0xEE,0x08,0xA0,0xD0,0xA5,0x9E,0x62,0x0B,0x53,0xBA,0x5F,0x82
		 },
		 {
		    0xFB,0xBB,0xF3,0xBE,0xD0,0xB8,0x0D,0x95,0xEA,0xBF,0x8D,0x38,0x1C,0x20,0xC3,0x19
		 },
		 /*TST_Key*/
		 {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
		 CRYS_AES_Key128BitSize,
		 /*TST_IvCounter*/
		 {0},
		 CRYS_AES_CMAC_mode,

	},
	#endif   
	#if TST_USE_FLOW_AES_XTSMode_DATA
	{ 
		{"Acceptance  flow test - AES/XTS/128Key/512ByteData "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4,
			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			4,
			0,
			/* TST_Expected_output_data */
		{
			0x32,0xc1,0x4b,0xf8,0x69,0x71,0x5b,0x16,0x03,0x9a,0xd1,0x46,0xef,0xf7,0x5b,0x22,
			0x59,0xae,0xa6,0xdb,0xa7,0x83,0xb6,0xdf,0x39,0xf6,0xa2,0xd6,0xcf,0x47,0x3e,0x35,
			0x50,0x38,0x1c,0x84,0x7d,0x78,0x0a,0xf7,0x78,0xf5,0xa4,0xed,0xcd,0xe6,0xda,0x08,
			0x14,0xfa,0x21,0x7b,0xa0,0x94,0xed,0xc6,0xb4,0x79,0xee,0xda,0x5a,0x94,0x21,0x0e,
			0x55,0x88,0x17,0xd1,0x88,0x75,0x9f,0x0e,0x7b,0xa4,0x4c,0xdd,0x27,0x0e,0xb3,0xf1,
			0x11,0x90,0x47,0xc9,0xed,0x1d,0xff,0x0c,0xad,0x64,0x68,0x20,0x34,0xf3,0xe7,0xae,
			0x42,0x7f,0xe3,0x7e,0xf5,0x4c,0x73,0xa6,0x04,0x21,0x66,0xd0,0x5a,0xcf,0xed,0x03,
			0x82,0xbf,0x8f,0x7e,0x7e,0x4a,0xf4,0xee,0x58,0x0e,0x59,0x44,0x2e,0x6e,0x32,0xf4,
			0x37,0xd3,0x9b,0x0b,0xf6,0x44,0x13,0x6b,0x62,0x10,0x04,0xc0,0x2a,0xe4,0x5d,0x16,
			0xf9,0x96,0xe5,0x26,0xd7,0x0f,0x95,0xb1,0x54,0x98,0xdd,0x10,0x15,0xea,0x56,0xb4,
			0x9d,0x2a,0x1b,0x0e,0x89,0xe1,0x5c,0xd8,0x8b,0x0a,0x75,0x08,0x02,0xe4,0xc0,0x10,
			0xee,0xe4,0x03,0x8f,0x5d,0x70,0x03,0x39,0x04,0xc9,0x79,0x63,0xc2,0x7d,0x88,0xf4,
			0x5a,0x5e,0x5f,0xb8,0x74,0x1e,0x70,0xb5,0x65,0x05,0x3e,0x43,0x35,0x7b,0xc2,0x7e,
			0x27,0xe2,0x35,0x6d,0xf3,0x8e,0x84,0x27,0x47,0xe2,0xe8,0xcd,0x18,0x71,0x43,0x4f,
			0xf9,0x6f,0xd4,0x3c,0x11,0x8e,0x78,0xda,0x7c,0x59,0x95,0xf9,0x04,0xbe,0xf3,0x49,
			0x95,0xce,0xdf,0x9c,0x91,0xbe,0x8d,0xd7,0x86,0x7e,0x44,0xb8,0x28,0xfc,0x18,0x7f,
			0x15,0x42,0xc2,0x11,0x7d,0xc3,0x1f,0xe8,0xac,0x43,0xc7,0x60,0x0d,0xac,0xac,0x98,
			0x57,0x3e,0x65,0xe5,0x9c,0xb6,0x68,0xaa,0x2a,0x6e,0x89,0x4d,0x69,0xc6,0x39,0x2e,
			0xc6,0x27,0x65,0xc9,0xfd,0xdb,0x1e,0x72,0x22,0x53,0x64,0x06,0x38,0x1a,0xd5,0xe8,
			0xd2,0x35,0x00,0xd7,0xb0,0xd1,0x42,0x0f,0xdf,0xe3,0xb7,0x2b,0x6d,0x2f,0xf1,0x8f,
			0x92,0xa4,0x11,0xaa,0x8b,0xbc,0xed,0x73,0x2e,0x19,0x89,0x17,0xae,0xe7,0xa1,0x16,
			0x7c,0xa0,0x13,0xd9,0x82,0x27,0x8d,0x95,0x24,0x8f,0xe0,0x76,0x57,0x79,0x9b,0x12,
			0x7a,0xd8,0x40,0xad,0xc4,0xd9,0xa3,0x1f,0x72,0x99,0x92,0xa5,0x28,0xa7,0x47,0x4f,
			0x0b,0xd1,0xd1,0xae,0x2f,0x54,0x54,0xa6,0xeb,0xdf,0x35,0xb3,0xd8,0x0a,0xaf,0xb0,
			0xde,0xd2,0xa8,0x05,0x31,0xb5,0x18,0xc1,0xd1,0xac,0x2f,0x9a,0xfc,0xd4,0x83,0x86,
			0x15,0x37,0xe4,0xe4,0x91,0x8c,0x65,0xc1,0x78,0x66,0x60,0x6f,0xa1,0x2d,0x50,0x6b,
			0xa9,0x73,0x92,0x36,0x33,0x35,0xba,0xf2,0x26,0x18,0x4f,0x71,0x85,0x49,0xba,0xe8,
			0x60,0x7a,0xc8,0xf1,0x6c,0x6f,0x80,0x8b,0x22,0x1b,0x57,0x4f,0xc6,0x6e,0x94,0x00,
			0x30,0x69,0xb2,0x5d,0x36,0x53,0x35,0x7d,0xf6,0x09,0xb1,0xe4,0x45,0xa1,0x8a,0x4a,
			0xbf,0x4a,0x81,0xb6,0x28,0xde,0x16,0x67,0x49,0xa6,0xbd,0x8c,0x7e,0x37,0x0f,0xa6,
			0xe8,0x64,0xa4,0x0e,0xb0,0xb8,0x7a,0x67,0xb0,0x70,0x7f,0xfc,0x3d,0x87,0x50,0x97,
			0x2a,0xfd,0xa2,0x1e,0xa8,0x17,0x98,0x49,0xc5,0x3b,0x6b,0xe0,0x33,0x76,0xd4,0x48
		},
		{
		    0
		 },
		/*TST_Key*/
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
		CRYS_AES_Key256BitSize,
		/*TST_IvCounter*/
		{0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
		CRYS_AES_XTS_mode,

	 },
	#endif   
};

const int TST_NumberOf_FLOW_AcceptanceTests = sizeof(TST_AESFLOW_Acceptance_TestData)/sizeof(TST_AESFLOW_Acceptance_TestData[0]);

#endif

